<?php
/*******************************************************************************
################################################################################
# $Id: dpagebreak.php 2010-10-31
# DPagebreak - DHTML document pagebreak plugin
# Copyright (C) 2010 gWorldz ~cXc~ All rights reserved.
# License http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL, see LICENSE.php
################################################################################
*******************************************************************************/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.plugin.plugin');
jimport('joomla.html.pagination');

class plgContentDPagebreak extends JPlugin
{
	var $pattern	= '#(<hr[^>]*?class=[\"|\']system-pagebreak[\"|\'][^(>|/>)]*?/?>)#iU';
	var $pluginPath;
	
    function plgContentDPagebreak(&$subject, $params)
    {
        parent::__construct($subject, $params);
		$this->pluginPath = dirname(__FILE__).DS.$this->_name;
		$this->loadLanguage( 'plg_'.$this->_type.'_'.$this->_name );
    }

	function onPrepareContent( $row, $params, $page=0 )
	{
		// Simple check to determine if plugin should process
        if (strpos($row->text, 'class="system-pagebreak') === false && strpos($row->text, 'class=\'system-pagebreak') === false){
            return true;
		}
		
		$print	= JRequest::getBool('print');
		$popped	= JRequest::getBool('pop');
		
		// Regex used for finding custom toc tags
		$regex1	= '/{tocstyle\s*.*?}/i';
		$regex2	= '/{tocstyle\s*(.*)?}/i';		
		$regex3 = '/\sh=.*/i';
		$regex4 = '/\sn=.*/i';
		$regex5 = '/\ss=.*/i';
		$regex6 = '/\sp=.*/i';
		$regex7 = '/\sh=(.*)?/i';
		$regex8 = '/\sn=(.*)?/i';
		$regex9 = '/\ss=(.*)?/i';
		$regex0 = '/\sp=(.*)?/i';
		
		// Check if the plugin is enabled
		if (!JPluginHelper::isEnabled('content', 'dpagebreak')){
			$row->text = preg_replace( $regex1, '', $row->text);
			$row->text = preg_replace( $this->pattern, '', $row->text );
			return;
		}

		// Check to see if we are printing
		if ($print || $popped){
			$row->text = preg_replace( $regex1, '', $row->text);
			$row->text = preg_replace( $this->pattern, '', $row->text );
			return;
		}
		
		// Check for section or category blog
		if ((JRequest::getVar('view') == "section" ) || (JRequest::getVar('view') == "category" )){
			$row->text = preg_replace( $regex1, '', $row->text);
			$row->text = preg_replace( $this->pattern, '', $row->text );
			return;
		}

		// Check to see if we are on homepage
		if (0 == $this->params->get('dpHomePage', 1)){
			$menu = &JSite::getMenu();
			if ((JRequest::getVar('Itemid', '') == $menu->getDefault()) || (JRequest::getVar('view') == "frontpage" )){
				$row->text = preg_replace( $regex1, '', $row->text);
				$row->text = preg_replace( $this->pattern, '', $row->text );
				return;
			}
		}
		
		// Find all instances of plugin
        $pagescount = preg_match_all( $this->pattern, $row->text, $pages, PREG_SET_ORDER );
		$texts		= preg_split( $this->pattern, $row->text );
		$textscount	= count($texts);
		if (2 == $this->params->get( 'dpTableIntro', 1)){
			$this->assignRef('title', $row->title);
			if ($row->title == ''){
				$row->title = $row->item_title;
			}
			if($row->title == ''){
				$row->title = $row->name;
			}
			$this->assignRef('item_title', $row->title);
		}
		$this->assignRef('pages', $pages);
		$this->assignRef('pagescount', $pagescount);
		$this->assignRef('texts', $texts);
		$this->assignRef('textscount', $textscount);

		// If there are no breaks then don't alter the article
		if ($this->textscount <= 1){
			return;
		}

		// Load the plugin language file
		$this->loadLanguage( 'plg_'.$this->_type.'_'.$this->_name, JPATH_ADMINISTRATOR );
				
		// Include mootools framework
		JHTML::_('behavior.mootools');
		
		$document	= JFactory::getDocument();
		$base 		= JURI::root(true).'/plugins/'.$this->_type.'/'.$this->_name;
		$media 		= JURI::root(true).'/media/'.$this->_name;
		
		// Start custom {tocstyle] tag check and processing
		$tocops		= '';
		$toctag		= preg_match( $regex2, $row->text, $toctags );
		if ($toctags){ 
			$tocops 	= $toctags[1];
		}
		$tocstyle	= preg_replace( $regex3, '', $tocops );
		$tocstyle	= preg_replace( $regex4, '', $tocstyle );
		$tocstyle	= preg_replace( $regex5, '', $tocstyle );
		$tocstyle	= preg_replace( $regex6, '', $tocstyle );
		$toctext	= preg_match( $regex7, $tocops, $textops );
		if ($textops){ 
			$textop		= $textops[1]; 
		}
		$tocnav		= preg_match( $regex8, $tocops, $tnavops );
		if ($tnavops){ 
			$tnavop		= $tnavops[1];
		}
		$pshowop	= preg_match( $regex9, $tocops, $showops );
		if ($showops){ 
			$showop		= $showops[1]; 
		}
		$pnavop		= preg_match( $regex0, $tocops, $pageops );
		if ($pageops){ 
			$pageop		= $pageops[1]; 
		}
		$this->assignRef('textop', $textop);
		$this->assignRef('tnavop', $tnavop);
		$this->assignRef('showop', $showop);
		$this->assignRef('pageop', $pageop);

		if (file_exists(JPATH_ROOT.DS.'media'.DS.'dpagebreak'.DS.$tocstyle.DS.'style.css')){
			$style	= trim( $tocstyle );
		}else{
			$style	= $this->params->get( 'dpUseStyle', 'Standard-List' );
		}

		if (method_exists($document, 'addScript')){
			$document->addScript($base.'/js/'.$this->_name.'.js');
		}
		
		if (1 == $this->params->get('dpAddStyle', 1)){
			if (method_exists($document, 'addStyleSheet')){
				$document->addStyleSheet($media.'/'.$style.'/style.css');
			}
		}else{
			if (method_exists($document, 'addStyleSheet')){
				$document->addStyleSheet($base.'/css/'.$this->_name.'.css');
			}
		}
		
		// Conditional IE6 Override (output = showall view)
		$ie6css = '<!--[if lte IE 6]>' ."\n";
		$ie6css .= '<link rel="stylesheet" href="/plugins/content/dpagebreak/css/ie6css.css" />' ."\n";
		$ie6css .= '<![endif]-->' ."\n";
		$document =& JFactory::getDocument();
		$document->addCustomTag($ie6css);
		
		$row->text = '';
		$showtoc = $this->params->get('dpShowTable', 1);
		$pagenav = $this->params->get('dpPageNav', 2);
		
		if (1 == $showtoc){
			if (0 != $pageop || '' == $pageop){
				if (1 == $pagenav){
					$row->text .= $this->loadTemplate('pagination');
				}
			}

			$row->text .= $this->loadTemplate('default');
			$row->text .= $this->_text;
		
			if (0 != $pageop || '' == $pageop){
				if (2 == $pagenav){
					$row->text .= $this->loadTemplate('pagination');
				}
			}
		}
		
		// Check if we should show the validation link
		$show = $this->params->get( 'dpValidation', 0);
		if ( $show && $show >= JFactory::getUser()->aid )
		{		
			$current	= JURI::current();
			$mark		= preg_match('/\?+/', $current) ? '&' : '?';
			$current	.= $mark.'tmpl=component';
			$this->assignRef('current', $current);
			
			$row->text	.= $this->loadTemplate('validate');
		}
		
		// Remove all tocstyle tags from item
		$row->text 	= preg_replace( $regex1, '', $row->text);

	}

	function _generateTOC( $index )
	{
		$result = new stdClass();
		
		if (0 == $index && $this->texts[$index] != ""){
			if (0 == $this->params->get( 'dpTableIntro', 1)){
				$result->title = $this->params->get('dpIntroText', 'Start');
			}elseif(1 == $this->params->get( 'dpTableIntro', 1)){
				$result->title = JText::_( 'DPAGEBREAK_TOC_START' );
			}else{
				$result->title = $this->item_title;
			}
			$result->name = $result->id = 'start';
			$this->pagescount++;
		}else{
			if ($this->texts[0] == ""){
				$attrs = JUtility::parseAttributes($this->pages[$index][0]);
			}else{
				$attrs = JUtility::parseAttributes($this->pages[$index-1][0]);
			}
			$result->title	= isset($attrs['title']) ? $attrs['title'] : 'unknown';
			$result->name	= isset($attrs['name']) ? $attrs['name'] : preg_replace('/\W/', '', $result->title);
			$result->id		= $result->name ? "$result->name" : 'start';
		}
		
		if ($this->texts[0] == ""){
			$this->_text .= '<div class="dpWrapPage" id="page-'.$result->id.'"> '.$this->texts[$index+1].'</div>';
		}else{
			$this->_text .= '<div class="dpWrapPage" id="page-'.$result->id.'"> '.$this->texts[$index].'</div>';	
		}
		
		return $result;	
	}

    function assignRef($key, &$val)
    {
        if (is_string($key) && substr($key, 0, 1) != '_'){
            unset($this->$key);
            $this->$key =& $val;
            return true;
        }
        return false;
    }

	function loadTemplate($name = 'default')
    {
        global $mainframe;
        $override = JPATH_SITE.DS.'templates'.DS.$mainframe->getTemplate().DS.'html'.DS.'plg_'.$this->_type.'_'.$this->_name.DS.$name.'.php';
        ob_start();
        if (is_readable($override)){
            include($override);
        }else if (is_readable($this->pluginPath.DS.'tmpl'.DS.$name.'.php')) {
            include($this->pluginPath.DS.'tmpl'.DS.$name.'.php');
        }else{
            ob_end_clean();
            JError::raiseError(500, JText::_('Failed to load template '.$name.'.php'));
            return '';
        }
        return trim(ob_get_clean());
    }
}
