<?php
/*******************************************************************************
################################################################################
# $Id: dpagebreak.php 2010-10-31
# DPagebreak Editor Button - DHTML document pagebreak editor button plugin
# Copyright (C) 2010 gWorldz ~cXc~ All rights reserved.
# License http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL, see LICENSE.php
################################################################################
*******************************************************************************/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.plugin.plugin' );

class plgButtonDPagebreak extends JPlugin
{
	function plgButtonDPagebreak(& $subject, $config)
	{
		parent::__construct($subject, $config);
	}

	function onDisplay($name)
	{
		global $mainframe;

		if (!JPluginHelper::isEnabled('content', 'dpagebreak')){
			return;
		}
		
		// Load the plugin language file
		$this->loadLanguage( 'plg_'.$this->_type.'_'.$this->_name, JPATH_ADMINISTRATOR );
		
		$css = ".button2-left .dpagebreak {
			background: transparent url(/plugins/editors-xtd/img/dpagebreak.png) no-repeat 100% 0px;
		}
		.button2-left .dpagebreak a:visited {
			text-decoration:none;
		}";
		if (JPluginHelper::isEnabled('editors-xtd', 'pagebreak')){
			$css .= "
			.pagebreak {
				display:none;
			}";
		}
		$doc = & JFactory::getDocument();
		$doc->addStyleDeclaration($css);
		$template = $mainframe->getTemplate();

		$link = 'index.php?option=com_content&amp;task=ins_pagebreak&amp;tmpl=component&amp;e_name='.$name;

		JHTML::_('behavior.modal');

		$button = new JObject();
		$button->set('modal', true);
		$button->set('link', $link);
		$button->set('text', JText::_('DPAGEBREAK_EXT_BTEXT'));
		$button->set('name', 'dpagebreak');
		$button->set('options', "{handler: 'iframe', size: {x: 400, y: 120}}");

		return $button;
	}
}