<?php
/*
* @package		AceSEF
* @subpackage	FLEXIcontent
* @copyright	2009 JoomAce LLC, www.joomce.net
* @license		http://www.joomace.net/company/license
*/

// No Permission
defined('_JEXEC') or die('Restricted access');

class AceSEF_com_flexicontent extends AceSEFTools {

	var $title_cat;
	var $title_item;
	var $desc_cat;
	var $desc_item;
	var $desc_item_metadesc;

	function getCategoryTitle($id) {
		$joomfish = $this->acesef_config->joomfish_trans_url ? ', id' : '';
		
		$cats = $this->params->get('category_inc', '3');
		$categories = array();
		$cat_title = array();
		
		if ($cats == '1')
            $id = 0; // No cat to add
		while ($id > 0) {
			$database =& JFactory::getDBO();
	        $database->setQuery("SELECT title, alias, parent_id, description$joomfish FROM #__categories WHERE id =".$id);
	        $rows = $database->loadRow();
			
	        $name = (($this->params->get('categoryid_inc', '1') != '1') ? $id.'-' : '');
			if(AceSEFTools::urlPart($this->params->get('category_part', 'global')) == 'title')
				$name .= $rows[0];
			else
				$name .= $rows[1];
				
			$this->desc_cat = $rows[3];
			
			array_unshift($categories, $name);
			array_unshift($cat_title, $rows[0]);
			
			$id = $rows[2];
			if ($cats == '2')
                break; //  Only last cat
        }
		$this->title_cat = $cat_title;
		return $categories;
    }

    function getItemTitle($id) {
		$joomfish = $this->acesef_config->joomfish_trans_url ? ', id' : '';
		
        $database =& JFactory::getDBO();
        $database->setQuery("SELECT title, alias, introtext, metadesc$joomfish FROM #__content WHERE id =".$id);
        $rows = $database->loadRow();
		
		$name = (($this->params->get('itemid_inc', '1') != '1') ? $id.'-' : '');
		if(AceSEFTools::urlPart($this->params->get('item_part', 'global')) == 'title')
			$name .= $rows[0];
		else
			$name .= $rows[1];
		
		$this->desc_item			= $rows[2];
		$this->desc_item_metadesc	= $rows[3];
		
		$this->title_item = $rows[0];
		
		return $name;
    }
	
	function getTagTitle($id){
        $database =& JFactory::getDBO();	
        $database->setQuery('SELECT name, alias FROM #__flexicontent_tags WHERE id ='.$id);
        $rows = $database->loadRow();
		
        $name = (($this->params->get('tagid_inc', '1') != '1') ? $id.'-' : '' );
		if(AceSEFTools::urlPart($this->params->get('tag_part', 'global')) == 'title')
			$name .= $rows[0];
		else
			$name .= $rows[1];
		
		$this->title_tag = $rows[0];
		
        return $name;
    }
	
	function getContentTitle($id){
        $database =& JFactory::getDBO();	
        $database->setQuery('SELECT title, alias FROM #__content WHERE id ='.$id);
        $rows = $database->loadRow();
		
        $name = (($this->params->get('contentid_inc', '1') != '1') ? $id.'-' : '' );
		if(AceSEFTools::urlPart($this->params->get('content_part', 'global')) == 'title')
			$name .= $rows[0];
		else
			$name .= $rows[1];
		
        return $name;
    }
	
	function getFieldTitle($id){
        $database =& JFactory::getDBO();	
        $database->setQuery('SELECT label FROM #__flexicontent_fields WHERE id ='.$id);
        $rows = $database->loadRow();
		
        $name = (($this->params->get('fieldid_inc', '1') != '1') ? $id.'-' : '' ).$rows[0];
        return $name;
    }
	
	function getItemCatId($id) {
        $database =& JFactory::getDBO();
        $database->setQuery("SELECT catid FROM #__content WHERE id = ".$id);
        $rows = $database->loadResult();
		return $rows;
    }
	
	function googleNews($title, $id) {
        $num = '';
        $add = $this->params->get('google_news', '1');

        if($add == '2') {
            // Article ID
            $digits = trim($this->params->get('google_news_digits', '3'));
            if(!is_numeric($digits)) {
                $digits = '3';
            }

            $num = sprintf('%0'.$digits.'d', $id);
        }
        else if($add == '3') {
            // Publish date
			$db =& JFactory::getDBO();
            $query = "SELECT `publish_up` FROM `#__content` WHERE `id` = '$id'";
            $db->setQuery($query);
            $time = $db->loadResult();

            $time = strtotime($time);

            $date = $this->params->get('google_news_dateformat', 'ddmm');

            $search = array('dd', 'd', 'mm', 'm', 'yyyy', 'yy');
            $replace = array(date('d', $time), date('j', $time), date('m', $time), date('n', $time), date('Y', $time), date('y', $time));
            $num = str_replace($search, $replace, $date);
        }

        if(!empty($num)) {
            $sep = $this->acesef_config->replacement_character;
            $where = $this->params->get('google_news_pos', '2');

            if($where == '2') {
                $title = $title.$sep.$num;
            } else {
                $title = $num.$sep.$title;
            }
        }

        return $title;
    }
	
	function beforeBuildRoute(&$uri) {
		if(!is_null($uri->getVar('id'))){
			AceSEFTools::fixUriVar($uri, 'id');
		}
			
		if(!is_null($uri->getVar('view') && $uri->getVar('view') == 'items' && (is_null($uri->getVar('cid')) || $uri->getVar('cid') == 0)) && !is_null($uri->getVar('id'))){
			$cid = $this->getItemCatId($uri->getVar('id'));
			if(!empty($cid)){
				$uri->setVar('cid', $cid);
			}
		}
        return;
    }

	function buildRoute(&$uri) {
		$vars = $uri->getQuery(true);
        extract($vars);
		$title = array();
		
		$cat_suffix 	= $this->params->get('cat_suffix', '1');
		$default_index	= $this->params->get('default_index', '');
		
		if(!empty($cid)){
			$title = array_merge($title, $this->getCategoryTitle($cid));
		}
		
		if(isset($view)) {
			switch($view) {
				case 'category':
					if($cat_suffix == '1' && $default_index == ''){
						$title[] = "/";
					}
					if($default_index != ''){
						$title[] = $default_index;
					}
					break;
				case 'items':
					if(!empty($id)){
						$title[] = $this->getItemTitle($id);
					}
					if(!empty($id) && $this->params->get('google_news', '1') != '1') {
						$i = count($title) - 1;
						$title[$i] = $this->googleNews($title[$i], $id);
					}
					break;
				case 'tags':
					$title[] = JText::_('Tags');
					if(!empty($id)){
						$title[] = $this->getTagTitle($id);
					}
					break;
				case 'favourites':
					$title[] = JText::_('FLEXI_MY_FAVOURITES');
					break;
				default:
					$title[] = $view;
			}
		}
	
		if(!empty($task)){
			switch ($task){
				case 'weblink':
					if(!empty($cid)){
						$title[] = $this->getContentTitle($cid);
					}
					if(!empty($fid)){
						$title[] = $this->getFieldTitle($fid);
					}
					break;
				default:
					$title[] = $task;
			}
		}
		
		if(!empty($ord)){
			$title[] = $ord;
		}
		
		return $title;
	}
	
	function metaTags(&$uri) {
		$vars = $uri->getQuery(true);
        extract($vars);
		
		$separator			= $this->params->get('separator', '-');
		$desc_length		= $this->params->get('desc_length', '250');
		$keywords_word		= $this->params->get('keywords_word', '3');
		$keywords_count		= $this->params->get('keywords_count', '15');
		$blacklist			= $this->params->get('blacklist', '');
		$item_desc			= $this->params->get('item_desc', '1');
		
		$acesef_title = $acesef_desc = $acesef_key = "";
		
		if (isset($view)){
			switch ($view){
				case 'category': 
					if(!empty($cid)){
						$acesef_title	= implode(" ".$separator." ", array_reverse($this->title_cat));
						$acesef_desc	= AceSEFTools::clipDesc($this->desc_cat, $desc_length);
						$acesef_key 	= AceSEFTools::generateKeywords($this->desc_cat, $blacklist, $keywords_count, $keywords_word);
					}
					break;
				case 'items': 
					if(!empty($id)){
						$acesef_title	= $this->title_item;
						if($item_desc == 1){
							$acesef_desc	= AceSEFTools::clipDesc($this->desc_item, $desc_length);
							$acesef_key 	= AceSEFTools::generateKeywords($this->desc_item, $blacklist, $keywords_count, $keywords_word);
						}
						else{
							$acesef_desc	= AceSEFTools::clipDesc($this->desc_item_metadesc, $desc_length);
							$acesef_key 	= AceSEFTools::generateKeywords($this->desc_item_metadesc, $blacklist, $keywords_count, $keywords_word);
						}
					}
					break;
				case 'tags':
					if(!empty($id))
						$acesef_title	= $this->title_tag;
					break;
			}
		}
		
		$meta = AceSEFTools::setMetaData($acesef_title, $acesef_desc, $acesef_key);
		
		return $meta;
	}
}
?>