<?php
/**
* @version		$Id: flexibreak.php 1 2010-05-03 14:10:00Z flowman $
* @package		FLEXIBreak Content Plugin
* @copyright	Copyright (C) 2005 - 2010 Otherland. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.plugin.plugin');
jimport('joomla.html.pagination');

class plgContentFlexiBreak extends JPlugin
{
    var $pattern = '#(<hr[^>]*?class=[\"|\']system-pagebreak[\"|\'][^(>|/>)]*?/?>)#iU';
	var $pluginPath;
    
    function plgContentFlexiBreak(&$subject, $params)
    {
        parent::__construct($subject, $params);
		$this->pluginPath = dirname(__FILE__).DS.$this->_name;
		$this->loadLanguage( 'plg_'.$this->_type.'_'.$this->_name );
    }

	function onPrepareContent( $row, $params, $page=0 )
	{
		//simple performance check to determine whether bot should process further
        if (strpos($row->text, 'class="system-pagebreak') === false && strpos($row->text, 'class=\'system-pagebreak') === false)
            return true;
		
		$print = JRequest::getBool('pop');
        if (!$this->params->get('enabled', 1))
            $print = true;

		if ($print)
		{
			$row->text = preg_replace( $this->pattern, '', $row->text );
			return;
		}
		
		// Find all instances of plugin
        $pagescount = preg_match_all( $this->pattern, $row->text, $pages, PREG_SET_ORDER );
		$texts		= preg_split( $this->pattern, $row->text );
		$textscount	= count($texts);
		$this->assignRef('pages', $pages);
		$this->assignRef('pagescount', $pagescount);
		$this->assignRef('texts', $texts);
		$this->assignRef('textscount', $textscount);

		// If there are no breaks then don't alter the article
		if ($this->textscount <= 1) 
			return;

		if ($this->params->get('plugin_js', 1))
		{
			JHTML::_('behavior.mootools');
			$document	= JFactory::getDocument();
			$base 		= JURI::root(true).'/plugins/'.$this->_type.'/'.$this->_name.'/'.$this->_name;

			if (method_exists($document, 'addScript'))
				$document->addScript($base.'.js');
			if ($this->params->get('plugin_css', 1))
			{
				if (method_exists($document, 'addStyleSheet'))
					$document->addStyleSheet($base.'.css');
			}

			$row->text = '';
            $pagenav = $this->params->get('pagination', 3);
            if (2 == $pagenav)
                $row->text .= $this->loadTemplate('pagination_js');
            $row->text .= $this->loadTemplate('default_js');
			$row->text .= $this->_text;
            if (3 == $pagenav)
                $row->text .= $this->loadTemplate('pagination_js');
		}
		else
		{
			$hasToc = $this->params->get( 'multipage_toc', 1 );
			if(!$page)
				$page = 0;
		
		}
	}
	
	function _generateToc( $index )
	{
		$result = new stdClass();
		
		if (0 == $index && $this->texts[$index] != "")
		{
			//$result->title	= $this->params->get('intro_text') != "" ? $this->params->get('intro_text') : $this->article->title ;
			$result->title = $this->params->get('intro_text', 'Start');
			$result->name = $result->id = 'start';
			$this->pagescount++;
		}
		else
		{
			if ($this->texts[0] == "")
				$attrs = JUtility::parseAttributes($this->pages[$index][0]);
			else
				$attrs = JUtility::parseAttributes($this->pages[$index-1][0]);
			$result->title	= isset($attrs['title']) ? $attrs['title'] : 'unknown';
			$result->name	= isset($attrs['name']) ? $attrs['name'] : preg_replace('/\W/', '', $result->title);
			$result->id		= $result->name ? "$result->name" : 'start';
		}
		if ($this->texts[0] == "")
			$this->_text .= '<div class="articlePage" id="'.$result->id.'"> '.$this->texts[$index+1].'</div>';
		else
			$this->_text .= '<div class="articlePage" id="'.$result->id.'"> '.$this->texts[$index].'</div>';	
		return $result;	
	}

    function assignRef($key, &$val)
    {
        if (is_string($key) && substr($key, 0, 1) != '_')
        {
            unset($this->$key);
            $this->$key =& $val;
            return true;
        }
        return false;
    }

	function loadTemplate($name = 'default')
    {
        global $mainframe;
        $override = JPATH_SITE.DS.'templates'.DS.$mainframe->getTemplate().DS.'html'.DS.'plg_'.$this->_type.'_'.$this->_name.DS.$name.'.php';
        ob_start();
        if (is_readable($override))
		{
            include($override);
        }
        else if (is_readable($this->pluginPath.DS.'tmpl'.DS.$name.'.php')) {
            include($this->pluginPath.DS.'tmpl'.DS.$name.'.php');
        }
        else
        {
            ob_end_clean();
            JError::raiseError(500, JText::_('Failed to load template '.$name.'.php'));
            return '';
        }
        return trim(ob_get_clean());
    }
}
