<?php
/**
 * @version 1.0 $Id: select.php 175 2009-11-07 10:24:30Z vistamedia $
 * @package Joomla
 * @subpackage FLEXIcontent
 * @subpackage plugin.select
 * @copyright (C) 2009 Emmanuel Danan - www.vistamedia.fr
 * @license GNU/GPL v2
 *
 * FLEXIcontent is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.event.plugin');

class plgFlexicontent_fieldsSelectdocman extends JPlugin
{
	function plgFlexicontent_fieldsSelectdocman( &$subject, $params )
	{
		parent::__construct( $subject, $params );
//		JPlugin::loadLanguage('plg_flexicontent_fields_selectdocman', JPATH_ADMINISTRATOR);
		
		global $_DOCMAN;
		require_once( JPATH_ADMINISTRATOR . DS. 'components' .DS. 'com_docman' .DS. 'docman.class.php');
		//DOCMan core interaction API
		$_DOCMAN = new dmMainFrame( _DM_TYPE_DOCLINK );

		// Load classes and language
		require_once( $_DOCMAN->getPath( 'classes', 'utils' ) );
	}

	function onDisplayField(&$field, $item)
	{
		// execute the code only if the field type match the plugin type
		if(substr($field->field_type, 0, 13) != 'selectarticle') return;

		// some parameter shortcuts
		$required 		= $field->parameters->get( 'required', 0 ) ;
		$type			= (int)$field->parameters->get( 'type', 0 ) ;
		
		$required 	= $required ? 'class="required"' : null;

		// initialise property
		if(!$field->value) {
			$field->value[0] = '';
		}
		
		$options = array(); 
		$options[] = JHTML::_('select.option', '', JText::_('FLEXI_PLEASE_SELECT'));
		
		if ($type == 0) {
			$this->_Documents($options);
		} else { // not implemented
			$this->_Categories($options);
		}
		$field->html = JHTML::_('select.genericlist', $options, $field->name, $required, 'value', 'text', $field->value);
	}


	function onBeforeSaveField( $field, &$post, &$file )
	{
		// execute the code only if the field type match the plugin type
		if(substr($field->field_type, 0, 13) != 'selectarticle') return;
		if(!$post) return;
	}


	function onDisplayFieldValue(&$field, $item, $values=null, $prop='display')
	{
		// execute the code only if the field type match the plugin type
		if(substr($field->field_type, 0, 13) != 'selectarticle') return;
		
		$values = $values ? $values : $field->value ;
		
		$values[0] = (int)$values[0];
		
		if ($values[0] <= 0) return;

		// some parameter shortcuts
		$pretext			= $field->parameters->get( 'pretext', '' ) ;
		$posttext			= $field->parameters->get( 'posttext', '' ) ;
		
		if ($pretext) 	{ $pretext . '&nbsp;'; }
		if ($posttext) 	{ '&nbsp;' . $posttext; }
		
		$results = $this->_Items($values[0]);
		if (count($results) == 0) return;
		
		$article = $results[0];
		
		$field->{$prop}	= (int)$values[0] . '/' . $article->id;
		//return;
		if ($article->state == 0) return;
		
		require_once (JPATH_SITE.DS.'components'.DS.'com_flexicontent'.DS.'helpers'.DS.'route.php');
		$link = FlexicontentHelperRoute::getItemRoute($article->id, $article->catid);
		
		$html = $pretext . '<a href="' . $link . '">' . $article->title . '</a>' . $posttext;
		
		$field->{$prop}	= $html;
	}
	
	function _Documents(&$options = array())
	{
		$cats = DOCMAN_Cats::getCategoryList();
		foreach($cats as $id => $cat) {
			$docs = DOCMAN_Docs::getDocsByUserAccess($id, 'name', '', $limit = '99999');
			foreach($docs as $doc) {
				$options[] = JHTML::_('select.option', $doc->id, $cat . '/' . $doc->title);
			}
		}
	}
	
	function _Categories(&$options = array())
	{
		
	}
	
}