<?php
/**
 * @version 1.0 $Id: select.php 175 2009-11-07 10:24:30Z vistamedia $
 * @package Joomla
 * @subpackage FLEXIcontent
 * @subpackage plugin.select
 * @copyright (C) 2009 Emmanuel Danan - www.vistamedia.fr
 * @license GNU/GPL v2
 *
 * FLEXIcontent is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
defined( '_JEXEC' ) or die( 'Restricted access' );

$fparams =& JComponentHelper::getParams('com_flexicontent');
if (!defined('FLEXI_SECTION')) define('FLEXI_SECTION', $fparams->get('flexi_section'));
if (!defined('FLEXI_ACCESS')) define('FLEXI_ACCESS', (JPluginHelper::isEnabled('system', 'flexiaccess') && version_compare(PHP_VERSION, '5.0.0', '>')) ? 1 : 0);

jimport('joomla.event.plugin');

class plgFlexicontent_fieldsSelectitem extends JPlugin
{
	function plgFlexicontent_fieldsSelectitem( &$subject, $params )
	{
		parent::__construct( $subject, $params );
		JPlugin::loadLanguage('plg_flexicontent_fields_selectitem', JPATH_ADMINISTRATOR);
	}

	function onDisplayField(&$field, $item)
	{
		// execute the code only if the field type match the plugin type
		if(substr($field->field_type, 0, 10) != 'selectitem') return;

		// some parameter shortcuts
		$required 	= $field->parameters->get( 'required', 0 ) ;
		$categories	= $field->parameters->get( 'category', '' ) ;
		if ($categories) $categories = explode(',', $categories);
		
		$required 	= $required ? 'class="required"' : null;
		
		// initialise property
		if(!$field->value) {
			$field->value[0] = '';
		}
		
		$document =& JFactory::getDocument();

		//add the drag and drop sorting feature
		$js = "
			window.addEvent('domready', function(){
				new Sortables($('sortables_".$field->id."'), {
					'handles': $('sortables_".$field->id."').getElements('span.drag'),
					'onDragStart': function(element, ghost){
						ghost.setStyles({
						   'list-style-type': 'none',
						   'opacity': 1
						});
						element.setStyle('opacity', 0.3);
					},
					'onDragComplete': function(element, ghost){
						element.setStyle('opacity', 1);
						ghost.remove();
						this.trash.remove();
					}
				});			
			});
			
			";
		$document->addScriptDeclaration($js);

		$js = "
			var curRowNum".$field->id."	= ".count($field->value).";
			var maxVal".$field->id."		= 4;

			function addField".$field->id."(el) {
				if((curRowNum".$field->id." < maxVal".$field->id.") || (maxVal".$field->id." == 0)) {

					var thisField 	 = $(el).getPrevious().getLast();
					var thisNewField = thisField.clone();
					var fx			 = thisNewField.effects({duration: 0, transition: Fx.Transitions.linear});
					thisNewField.getFirst().setProperty('value','');

					thisNewField.injectAfter(thisField);
		
					new Sortables($('sortables_".$field->id."'), {
						'handles': $('sortables_".$field->id."').getElements('span.drag'),
						'onDragStart': function(element, ghost){
							ghost.setStyles({
							   'list-style-type': 'none',
							   'opacity': 1
							});
							element.setStyle('opacity', 0.3);
						},
						'onDragComplete': function(element, ghost){
							element.setStyle('opacity', 1);
							ghost.remove();
							this.trash.remove();
						}
					});			

					fx.start({ 'opacity': 1 }).chain(function(){
						this.setOptions({duration: 600});
						this.start({ 'opacity': 0 });
						})
						.chain(function(){
							this.setOptions({duration: 300});
							this.start({ 'opacity': 1 });
						});

					curRowNum".$field->id."++;
					}
				}

			function deleteField".$field->id."(el) {
				if(curRowNum".$field->id." > 1) {

				var field	= $(el);
				var row		= field.getParent();
				var fx		= row.effects({duration: 300, transition: Fx.Transitions.linear});
				
				fx.start({
					'height': 0,
					'opacity': 0			
					}).chain(function(){
						row.remove();
					});
				curRowNum".$field->id."--;
				}
			}
			";
		$document->addScriptDeclaration($js);
		
		$css = '
			#sortables_'.$field->id.' { margin: 0px; padding: 0px; list-style: none; white-space: nowrap; }
			#sortables_'.$field->id.' li {
				list-style: none;
				height: 20px;
				width:500px;
				}
			#sortables_'.$field->id.' li.sortabledisabled {
				background : transparent url(components/com_flexicontent/assets/images/move3.png) no-repeat 0px 1px;
				}
			#sortables_'.$field->id.' li input { cursor: text;}
			#sortables_'.$field->id.' li input.fcbutton, .fcbutton { cursor: pointer; margin-left: 3px; }
			span.drag img {
				margin: -4px 8px;
				cursor: move;
			}
			';
		$document->addStyleDeclaration($css);

		$move2 	= JHTML::image ( 'administrator/components/com_flexicontent/assets/images/move3.png', JText::_( 'FLEXI_CLICK_TO_DRAG' ) );
		$n = 0;
		$field->html = '<ul id="sortables_'.$field->id.'">';

		// generate the options
		$results = $this->_Items();
		$options = array(); 
		$options[] = JHTML::_('select.option', '', JText::_('FLEXI_PLEASE_SELECT'));
		$display = "";
		foreach($results as $result) {
			if (!$categories || in_array($result->catid, $categories))
				$options[] = JHTML::_('select.option', $result->value, $result->text . ($result->state == 0 ? ' (unpublished)' : ''));
		}
		if ($categories) {
			// now walk recursively through the results to add the subitems of the given categories
			foreach($categories as $cat) {
				$this->_getSubs($options, $results, (int)$cat);
			}
		}
		
		foreach ($field->value as $value) {
			$field->html .= '<li>' . JHTML::_('select.genericlist', $options, $field->name . '[]', $required, 'value', 'text', $value) . '<input class="fcbutton" type="button" value="'.JText::_( 'FLEXI_REMOVE_VALUE' ).'" onclick="deleteField'.$field->id.'(this);" /><span class="drag">'.$move2.'</span></li>';
		}
		$field->html .=	'</ul>';
		$field->html .= '<input type="button" id="add'.$field->name.'" onclick="addField'.$field->id.'(this);" value="'.JText::_( 'FLEXI_ADD_VALUE' ).'" />';

	}
	
	function _getSubs(&$options, &$results, $category, $prefix = '') {
		$allready = array();
		foreach($results as $result) {
			if ($result->parentcat == $category) {
				if ($result->catid && !in_array($result->catid, $allready)) {
					$allready[] = $result->catid;
					$this->_getSubs($options, $results, $result->catid, $prefix . $result->cattitle . '/');
				}
				$options[] = JHTML::_('select.option', $result->value, $prefix . $result->cattitle . '/' . $result->text . ($result->state == 0 ? ' (unpublished)' : ''));
			}
		}
	}


	function onBeforeSaveField( $field, &$post, &$file )
	{
		// execute the code only if the field type match the plugin type
		if(substr($field->field_type, 0, 10) != 'selectitem') return;
		if(!$post) return;
		
		$newpost = array();
		$new = 0;

		foreach ($post as $n=>$v)
		{
			if ($post[$n] != '')
			{
				$newpost[$new] = $post[$n];
			}
			$new++;
		}
		$post = $newpost;
	}


	function onDisplayFieldValue(&$field, $item, $values=null, $prop='display')
	{
		// execute the code only if the field type match the plugin type
		if(substr($field->field_type, 0, 10) != 'selectitem') return;
		
		$values = $values ? $values : $field->value ;
		if (count($values) == 0) return;
		
		$icon = $field->parameters->get( 'icon', '' ) ;
		if ($icon) {
			if (substr($icon,0,1) != '/') $icon = '/images/stories/' . $icon;
			$field->label .= '&nbsp;&nbsp;<img src="' . $icon . '" align="absmiddle" />';
		}

		// some parameter shortcuts
		$pretext			= $field->parameters->get( 'pretext', '' ) ;
		$posttext			= $field->parameters->get( 'posttext', '' ) ;
		
		if ($pretext) 	{ $pretext . '&nbsp;'; }
		if ($posttext) 	{ '&nbsp;' . $posttext; }
		
		$showfiles	= $field->parameters->get( 'showfiles', 0 ) == 1 ;
		$showtip	= $field->parameters->get( 'showtip', 1 ) == 1 ;
		$useicon	= $field->parameters->get( 'useicon', 1 ) ;
		$icontype	= $field->parameters->get( 'icontype', '16' ) ;
		if ($showfiles) {
			JHTML::_('behavior.tooltip');
		}
		
		// some parameter shortcuts
		$separatorf = (int)$field->parameters->get( 'separatorf', 1 ) ;
		
		switch($separatorf)
		{
			case 0:
				$separator = '&nbsp;&nbsp;&nbsp;1';
				break;

			case 1:
				$separator = '<br />';
				break;

			case 2:
				$separator = '&nbsp;&nbsp;|&nbsp;&nbsp;';
				break;

			case 3:
				$separator = ',&nbsp;';
				break;
			
			case 4:
				$separator = '</li><li>';
				break;

			default:
				$separator = '&nbsp;&nbsp;&nbsp;';
				break;
		}

		$items = array();		
		$n = 0;
		foreach ($values as $value) {
			
			$results = $this->_Items($value);
			if ($showfiles)
				$files = $this->_Files($value);
				
			if (count($results) == 0) continue;
			
			$item = $results[0];
			
			//$field->{$prop}	= (int)$values[0] . '/' . $item->id;
			//return;
			if ($item->state == 0) return;
			
			if ($showfiles) {
				
				$count = count($files);
				
				foreach ($files as $file) {
					$tip = '';
					$icon = '';
					if ($file) {
						if ($showtip && !$file->url) {
							$tip = $file->filename . '::<table cellpadding=0 cellspacing=0><tr><th scope=row>' . JText::_('FLEXI_SELECTITEM_ADDED') . '</th><td>' . strftime('%d-%m-%Y', strtotime($item->publish_up)) . '</td></tr><tr><th scope=row>' . JText::_('FLEXI_SELECTITEM_TYPE') . '</th><td>' . $file->ext . '</td></tr><tr><th scope=row>' . JText::_('FLEXI_SELECTITEM_SIZE') . '</th><td>' . $this->getSize(@filesize(COM_FLEXICONTENT_FILEPATH . DS . $file->filename)) . '</td></tr></table>';
						}
						if ($useicon) {
							$file	= $this->addIcon( $file, $icontype );
							$icon	= JHTML::image($file->icon, $file->ext, 'class="icon-mime" width="16" height="16" align="absmiddle"') .'&nbsp;';
						}
						$items[] = $icon . '<a' . ($tip ? ' class="hasTip" title="'.$tip.'"' : '') . ' href="' . JRoute::_( 'index.php?id='. $file->id .'&cid='.$item->id.'&fid='.$file->field_id.'&task=download' ) . '">' . ($count > 1 ? $file->altname : $item->title) . '</a>';
					}
				}
				
			} else {
				
				require_once (JPATH_SITE.DS.'components'.DS.'com_flexicontent'.DS.'helpers'.DS.'route.php');
				$link = JRoute::_(FlexicontentHelperRoute::getItemRoute($item->id, $item->catid));
				$field->link = $link;
				$items[] = $pretext . '<a href="' . $link . '">' . $item->title . '</a>' . $posttext;
				
			}
			
		}
		
		$field->{$prop} = ($showfiles ? '<div class="fileblock">' : '') . ($separatorf == 4 && count($items) > 1 ? '<ul><li>' : '') . implode($separator, $items) . ($separatorf == 4 && count($items) > 1 ? '</li></ul>' : '') . ($showfiles ? '</div>' : '');
	}
	
	function _Items($id = 0, $cid = 0)
	{
		$db		=& JFactory::getDBO();
		//$user	=& JFactory::getUser();
		//$aid	= (int)$user->get('aid');
		
		$and = ($id > 0 ? 'i.id = ' . $id : 'true');
		$and .= ($cid > 0 ? ' AND c.id = ' . $cid : '');
		
		$query	= 'SELECT i.id AS value, i.title AS text, i.*, i.catid AS icatid, c.access AS cataccess, c.id AS catid, c.published AS catpublished, c.title AS cattitle, c.parent_id AS parentcat,'
			. ' CASE WHEN CHAR_LENGTH(i.alias) THEN CONCAT_WS(\':\', i.id, i.alias) ELSE i.id END as slug,'
			. ' CASE WHEN CHAR_LENGTH(c.alias) THEN CONCAT_WS(\':\', c.id, c.alias) ELSE c.id END as categoryslug'
			. ' FROM #__content AS i'
			. ' LEFT JOIN #__flexicontent_cats_item_relations AS rel ON rel.itemid = i.id'
			. ' LEFT JOIN #__categories AS c ON c.id = rel.catid'
			. ' WHERE '
			. $and
			. ' ORDER BY c.title, i.title, rel.ordering, i.ordering ASC'
		;
		//echo $query;
		$db->setQuery($query);
		$rows = $db->loadObjectList();
		if ($db->getErrorNum() > 0) echo $db->getErrorMsg();
		
		return $rows;
	}
	
	function _Files($id)
	{
		$db		=& JFactory::getDBO();
		
		$query = 
			'SELECT f.id, f.filename, f.altname, LOWER(f.ext) as ext, f.url, rel.field_id
				FROM #__flexicontent_fields_item_relations AS rel 
					INNER JOIN #__flexicontent_fields AS fld ON fld.id = rel.field_id 
					INNER JOIN #__flexicontent_files AS f ON f.id = rel.value 
				WHERE rel.item_id = ' . $id . ' AND fld.field_type = ' . $db->Quote('file') . ' 
				ORDER BY rel.valueorder';
		
		$db->setQuery($query);
		$rows = $db->loadObjectList();
		if ($db->getErrorNum() > 0) echo $db->getErrorMsg();
		
		return $rows;
	}
	
	function getSize($size)
	{
		$kb = 1024;
		$mb = 1024 * $kb;
		$gb = 1024 * $mb;
		$tb = 1024 * $gb;
		$file_size = 0;

		if ($size) {
			if ($size < $kb) {
				$file_size = $size .' Bytes';
			}
			elseif ($size < $mb) {
				$final = round($size/$kb,2);
				$file_size = $final .' Kb';
			}
			elseif ($size < $gb) {
				$final = round($size/$mb,2);
				$file_size = $final .' MB';
			}
			elseif($size < $tb) {
				$final = round($size/$gb,2);
				$file_size = $final .' GB';
			} else {
				$final = round($size/$tb,2);
				$file_size = $final .' TB';
			}
		}
		return $file_size;
	}

	function addIcon( &$file, $type = '16' )
	{
		switch ($file->ext)
		{
			// Image
			/*
			case 'jpg':
			case 'png':
			case 'gif':
			case 'xcf':
			case 'odg':
			case 'bmp':
			case 'jpeg':
				$file->icon = 'components/com_flexicontent/assets/images/mime-icon-16/image.png';
			break;
			*/

			// Non-image document
			default:
				$icon = JPATH_SITE.DS.'components'.DS.'com_flexicontent'.DS.'assets'.DS.'images'.DS.'mime-icon-'.$type.DS.$file->ext.'.png';
				if (file_exists($icon)) {
					$file->icon = 'components/com_flexicontent/assets/images/mime-icon-'.$type.'/'.$file->ext.'.png';
				} elseif (file_exists(JPATH_SITE.DS.'components'.DS.'com_flexicontent'.DS.'assets'.DS.'images'.DS.'mime-icon-'.$type.DS.'generic.png')) {
					$file->icon = 'components/com_flexicontent/assets/images/mime-icon-'.$type.'/generic.png';
				} else {
					$file->icon = '';
				}
				break;
		}
		return $file;
	}
	
}